/*------------------------------------------------------\
|                                                       |
|  Title   :   Structures and fonctions for SCL         |
|                                                       |
|  File    :            sch103.h                        |
|                                                       |
|  Date    :            04.03.98                        |
|                                                       |
|  Authors :         Picault   Stephane                 |
|                    Miramond    Benoit                 |
|                                                       |
\------------------------------------------------------*/

# ifndef SCL_103_H
# define SCL_103_H

/*------------------------------------------------------\
|                                                       |
|                      Constants                        |
|                                                       |
\------------------------------------------------------*/


# define SCH_FROM_LO        0x0001
# define SCH_FROM_CNS       0x0002

# define SCH_NET_TYPE       0x90000020
# define SCH_BOX_TYPE       0x90000200

# define SCH_BOX_TAGED         0x0001 
# define SCH_BOX_RETAGED       0x0100 
# define SCH_BOX_CLUSTERISED   0x0002
# define SCH_BOX_CLUSTER       0x0004
# define SCH_BOX_TRANSPARENCE  0x0008
# define SCH_BOX_PLACED        0x1000


# define SCH_CON_IN         0x0001
# define SCH_CON_OUT        0x0002
# define SCH_CON_EXTERNAL   0x0010
# define SCH_CON_INTERNAL   0x0020
# define SCH_CON_TAGED      0x0100
# define SCH_CON_PLACED     0x0200

# define SCH_NET_CANAL      0x0F

# define SCH_NET_MAXDIR     0x20
# define SCH_NET_MINDIR     0x10

# define SCH_ROOT_CON_BOX   0x0001
# define SCH_ROOT_CON_FIG   0x0002


# define SCH_SOURCE_LOSIG   0x01 
# define SCH_SOURCE_LOINS   0x02
# define SCH_SOURCE_LOCON   0x03
# define SCH_SOURCE_LOFIG   0x04
# define SCH_SOURCE_CNSFIG  0x05
# define SCH_SOURCE_CNSCONE 0x06
# define SCH_SOURCE_CNSEDGE 0x07

/*------------------------------------------------------\
|                                                       |
|                        Macros                         |
|                                                       |
\------------------------------------------------------*/

# define IsSchBoxClusterised( X )   ( ( X )->FLAGS & SCH_BOX_CLUSTERISED )
# define IsSchBoxTaged( X )         ( ( X )->FLAGS & SCH_BOX_TAGED )
# define IsSchBoxReTaged( X )         ( ( X )->FLAGS & SCH_BOX_RETAGED )
# define IsSchBoxCluster( X )       ( ( X )->FLAGS & SCH_BOX_CLUSTER )
# define IsSchBoxTransparence( X )  ( ( X )->FLAGS & SCH_BOX_TRANSPARENCE )
# define IsSchBoxPlaced( X )        ( ( X )->FLAGS & SCH_BOX_PLACED )

# define IsSchConIn( X )          ( ( X )->TYPE & SCH_CON_IN )
# define IsSchConOut( X )         ( ( X )->TYPE & SCH_CON_OUT )
# define IsSchConExternal( X )    ( ( X )->TYPE & SCH_CON_EXTERNAL )
# define IsSchConInternal( X )    ( ( X )->TYPE & SCH_CON_INTERNAL )
# define IsSchConTaged( X )       ( ( X )->FLAGS & SCH_CON_TAGED )
# define IsSchConPlaced( X )      ( ( X )->FLAGS & SCH_CON_PLACED )

# define IsSchNetCanal( X )        ( ( X )->FLAGS & SCH_NET_CANAL )

# define GetSchNetDirType( X )     ( ( X )->FLAGS & (SCH_NET_MAXDIR|SCH_NET_MINDIR) )

# define SetSchNetMaxOutput( X )     ( ( X )->FLAGS |= SCH_NET_MAXDIR )
# define SetSchNetMinOutput( X )     ( ( X )->FLAGS |= SCH_NET_MINDIR )

# define SetSchBoxClusterised( X )  ( ( X )->FLAGS |= SCH_BOX_CLUSTERISED )
# define SetSchBoxTaged( X )        ( ( X )->FLAGS |= SCH_BOX_TAGED )
# define SetSchBoxReTaged( X )        ( ( X )->FLAGS |= SCH_BOX_RETAGED )
# define SetSchBoxCluster( X )      ( ( X )->FLAGS |= SCH_BOX_CLUSTER )
# define SetSchBoxTransparence( X ) ( ( X )->FLAGS |= SCH_BOX_TRANSPARENCE )
# define SetSchBoxPlaced( X )       ( ( X )->FLAGS |= SCH_BOX_PLACED )

# define SetSchConExternal( X )   ( ( X )->TYPE |= SCH_CON_EXTERNAL )
# define SetSchConInternal( X )   ( ( X )->TYPE |= SCH_CON_INTERNAL )
# define SetSchConTaged( X )      ( ( X )->FLAGS |= SCH_CON_TAGED )
# define SetSchConPlaced( X )     ( ( X )->FLAGS |= SCH_CON_PLACED )

# define SetSchNetCanal( X )       ( ( X )->FLAGS |= SCH_NET_CANAL )

# define ClearSchNetCanal( X )     ( ( X )->FLAGS &= ~SCH_NET_CANAL )
# define ClearSchNetDir( X )       ( ( X )->FLAGS &= ~(SCH_NET_MINDIR|SCH_NET_MAXDIR) )

# define addschfigconin( F, N )  (addschfigcon( (F), (N), SCH_CON_IN ))
# define addschfigconout( F, N ) (addschfigcon( (F), (N), SCH_CON_OUT ))

# define addschboxconin( F, B, N )  (addschboxcon( (F), (B), (N), SCH_CON_IN ))
# define addschboxconout( F, B, N ) (addschboxcon( (F), (B), (N), SCH_CON_OUT ))

/*------------------------------------------------------\
|                                                       |
|                      Structures                       |
|                                                       |
\------------------------------------------------------*/



/*------------------------------------------------------\
|                                                       |
|                        Wires                          |
|                                                       |
\------------------------------------------------------*/

  typedef struct schwir_list
  {
    struct schwir_list  *NEXT;
    struct schnet_list  *NET;
    long                 X;
    long                 Y;
    long                 DX;
    long                 DY;
    long                 FLAGS;
    void                *USER;

  } schwir_list;

/*------------------------------------------------------\
|                                                       |
|                        Nets (Signals)                 |
|                                                       |
\------------------------------------------------------*/

  typedef struct schnet_list 
  {
    struct schnet_list  *NEXT;
    chain_list          *CON_NET;
    struct schwir_list  *WIRE;
    void                *SOURCE;
    unsigned char        SOURCE_TYPE;    /* type de la source */ 
    long                 FLAGS;
    long                 NUMBER_IN;
    long                 NUMBER_OUT;
    long                 CANAL;         /* pour routage ... */
    long                 YMIN;        /* pour routage ... */
    long                 YMAX;      /* pour routage ... */
    void                *USER;
    
  } schnet_list;


/*------------------------------------------------------\
|                                                       |
|                      Connectors                       |
|                                                       |
\------------------------------------------------------*/

  typedef struct schcon_list 
  {
    struct schcon_list  *NEXT;
    char                *NAME;
    unsigned char        TYPE;
    unsigned char        DIR;
    unsigned char        ROOT_TYPE;
    void                *ROOT;
    schnet_list         *NET;
    void                *SOURCE;
    unsigned char        SOURCE_TYPE;
    long                 X_REL;
    long                 Y_REL;
    long                 FLAGS;
    void                *USER;
    
  } schcon_list;


/*------------------------------------------------------\
|                                                       |
|                        Box (Instance)                 |
|                                                       |
\------------------------------------------------------*/

  typedef struct schbox_list 
  {
    struct schbox_list  *NEXT;
    char                *NAME;
    struct schcon_list  *CON_IN;
    long                 NUMBER_IN;
    struct schcon_list  *CON_OUT;
    long                 NUMBER_OUT;
    void                *SOURCE;
    unsigned char        SOURCE_TYPE;    /* type de la source */ 
    long                 X;
    long                 Y;
    long                 DX;
    long                 DY;
    long                 FLAGS;
    void                *USER;
   
  } schbox_list;

/*------------------------------------------------------\
|                                                       |
|                        Figure                         |
|                                                       |
\------------------------------------------------------*/

  typedef struct schfig_list 
  {
    struct schfig_list  *NEXT;
    char                *NAME;    
    struct schcon_list  *CON_IN;
    long                 NUMBER_IN;
    struct schcon_list  *CON_OUT;
    long                 NUMBER_OUT;
    schbox_list         *BOX;
    schnet_list         *NET;
    void                *SOURCE;
    unsigned char        SOURCE_TYPE;    /* type de la source */ 
    long                 X;
    long                 Y;
    long                 FLAGS;
    void                *USER;
   
  } schfig_list;

/*------------------------------------------------------\
|                                                       |
|                     Global Variables                  |
|                                                       |
\------------------------------------------------------*/

 extern schfig_list   *HEAD_SCHFIG;

/*------------------------------------------------------\
|                                                       |
|                        Functions                      |
|                                                       |
\------------------------------------------------------*/
/*------------------------------------------------------\
|                                                       |
|                    Alloc Functions                    |
|                                                       |
\------------------------------------------------------*/

  extern schfig_list    *allocschfig();
  extern schcon_list    *allocschcon();
  extern schbox_list    *allocschbox();
  extern schwir_list    *allocschwir();
  extern schnet_list    *allocschnet();


/*------------------------------------------------------\
|                                                       |
|                      Free Functions                   |
|                                                       |
\------------------------------------------------------*/

  extern void  freeschfig();
  extern void  freeschcon();
  extern void  freeschbox();
  extern void  freeschwir();
  extern void  freeschnet();


/*------------------------------------------------------\
|                                                       |
|                      Add Functions                    |
|                                                       |
\------------------------------------------------------*/

  extern schnet_list    *addschnetcon();
  extern schfig_list    *addschfig();
  extern schcon_list    *addschfigcon();
  extern schcon_list    *addschboxcon();
  extern schbox_list    *addschbox();
  extern schwir_list    *addschwir();
  extern schnet_list    *addschnet();
  

/*------------------------------------------------------\
|                                                       |
|                      Del Functions                    |
|                                                       |
\------------------------------------------------------*/

  extern int   delschfig();

/*------------------------------------------------------\
|                                                       |
|                      Search Functions                 |
|                                                       |
\------------------------------------------------------*/

/*------------------------------------------------------\
|                                                       |
|                     View Functions                    |
|                                                       |
\------------------------------------------------------*/

  extern void viewschfig();
  extern void viewschbox();
  extern void viewschcon();
  extern void viewschwir();
  extern void viewschnet();

  extern schfig_list *getschfig();
  extern void         buildschfig();

# endif 
