#ifndef __P
# if defined(__STDC__) ||  defined(__GNUC__)
#  define __P(x) x
# else
#  define __P(x) ()
# endif
#endif
/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RTL                           |
|                                                             |
| File    :                   rtn101.h                        |
|                                                             |
| Author  :                 Jacomme Ludovic                   |
|                                                             |
| Date    :                   25.08.97                        |
|                                                             |
\------------------------------------------------------------*/

# ifndef RTN_101_H
# define RTN_101_H

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           Rtl Direction                     |
|                                                             |
\------------------------------------------------------------*/

# define RTL_DIR_IN         0
# define RTL_DIR_OUT        1
# define RTL_DIR_INOUT      2
# define RTL_MAX_DIR_TYPE   3

/*------------------------------------------------------------\
|                                                             |
|                           Rtl Kind                          |
|                                                             |
\------------------------------------------------------------*/

# define RTL_KIND_NONE      0
# define RTL_KIND_BUS       1
# define RTL_KIND_REGISTER  2
# define RTL_MAX_KIND_TYPE  3

/*------------------------------------------------------------\
|                                                             |
|                          Rtl Declar Type                    |
|                                                             |
\------------------------------------------------------------*/

# define RTL_DECLAR_PORT       0
# define RTL_DECLAR_SIGNAL     1
# define RTL_DECLAR_CONSTANT   2
# define RTL_MAX_DECLAR_TYPE   3

/*------------------------------------------------------------\
|                                                             |
|                        Rtl Assgin Type                      |
|                                                             |
\------------------------------------------------------------*/

# define RTL_ASG_COMBINATORIAL      0
# define RTL_ASG_MULTIPLEXOR        1
# define RTL_ASG_CONDITIONAL        2
# define RTL_ASG_REGISTER           3
# define RTL_ASG_TRISTATE           4
# define RTL_ASG_PULL_UP            5
# define RTL_ASG_PULL_DOWN          6
# define RTL_MAX_ASG_TYPE           7

/*------------------------------------------------------------\
|                                                             |
|                   Rtl Assgin Register Type                  |
|                                                             |
\------------------------------------------------------------*/

# define RTL_ASG_REGISTER_NONE      0
# define RTL_ASG_REGISTER_SYNC      1
# define RTL_ASG_REGISTER_ASYNC     2
# define RTL_ASG_REGISTER_MIXED     3
# define RTL_MAX_ASG_REGISTER_TYPE  4

/*------------------------------------------------------------\
|                                                             |
|                        Rtl Bi Vex Type                      |
|                                                             |
\------------------------------------------------------------*/

# define RTL_BIVEX_NONE               0
# define RTL_BIVEX_FALLING_EDGE       1
# define RTL_BIVEX_RISING_EDGE        2
# define RTL_BIVEX_ASYNC_RESET        3
# define RTL_BIVEX_ASYNC_SET          4
# define RTL_BIVEX_ASYNC_WEN          5
# define RTL_BIVEX_SYNC_RESET         6
# define RTL_BIVEX_SYNC_SET           7
# define RTL_BIVEX_SYNC_WEN           8
# define RTL_BIVEX_MULTIPLEXOR        9
# define RTL_BIVEX_CONDITIONAL       10
# define RTL_MAX_BIVEX_TYPE          11

/*------------------------------------------------------------\
|                                                             |
|                           Rtl Fsm Type                      |
|                                                             |
\------------------------------------------------------------*/

# define RTL_FSM_STANDARD           0
# define RTL_FSM_REGOUT             1
# define RTL_MAX_FSM_TYPE           2

/*------------------------------------------------------------\
|                                                             |
|                            Macro                            |
|                                                             |
\------------------------------------------------------------*/

# define GetRtlFsmTrans( C ) ((rtlfsmtrans_list *)((C)->DATA))

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Rtl Symbol                         |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rtlsym
  {
    char                  *NAME;
    struct rtldecl_list   *DECL;
    short                  INDEX;
    unsigned char          INIT;
    unsigned char          DRIVE;
    unsigned char          EFFEC;
    unsigned char          EVENT;
    long                   FLAGS;
    void                  *USER;

  } rtlsym;

/*------------------------------------------------------------\
|                                                             |
|                          Rtl Declaration                    |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rtldecl_list
  {
    struct rtldecl_list  *NEXT;
    vexexpr              *VEX_ATOM;
    vexexpr              *VEX_INIT;
    rtlsym               *DECL_SYM;
    unsigned char         DIR;
    unsigned char         TYPE;
    unsigned char         KIND;
    unsigned char         BASE;
    long                  FLAGS;
    void                 *USER;

  } rtldecl_list;

/*------------------------------------------------------------\
|                                                             |
|                           Rtl Bi Vex                        |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rtlbivex_list 
  {
    struct rtlbivex_list *NEXT;
    unsigned char         TYPE;
    vexexpr              *VEX_COND;
    vexexpr              *VEX_DATA;
    long                  FLAGS;
    void                 *USER;

  } rtlbivex_list;

/*------------------------------------------------------------\
|                                                             |
|                       Rtl Assignment                        |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rtlasg_list
  {
    struct rtlasg_list    *NEXT;
    struct rtlasg_list   **PREV;
    vexexpr               *VEX_ATOM;
    vexexpr               *VEX_DATA;
    rtlbivex_list         *BIVEX;
    rtlbivex_list        **LAST_BIVEX;
    unsigned char          TYPE;
    unsigned char          REG_TYPE;
    long                   FLAGS;
    void                  *USER;

  } rtlasg_list;

/*------------------------------------------------------------\
|                                                             |
|                       Rtl Fsm Assignment                    |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rtlfsmasg_list
  {
    struct rtlfsmasg_list    *NEXT;
    vexexpr                  *VEX_ATOM;
    vexexpr                  *VEX_DATA;
    long                      FLAGS;
    void                     *USER;

  } rtlfsmasg_list;

/*------------------------------------------------------------\
|                                                             |
|                          Rtl Fsm State                      |
|                                                             |
\------------------------------------------------------------*/

 typedef struct rtlfsmstate_list
 {
   struct rtlfsmstate_list *NEXT;
   char                    *NAME;
   chain_list              *FROM;
   chain_list              *TO;
   rtlfsmasg_list          *ASSIGN;
   long                     FLAGS;
   void                    *USER;
   
 } rtlfsmstate_list;

/*------------------------------------------------------------\
|                                                             |
|                          Rtl Fsm Transition                 |
|                                                             |
\------------------------------------------------------------*/

 typedef struct rtlfsmtrans_list
 {
   struct rtlfsmtrans_list *NEXT;
   struct rtlfsmstate_list *FROM;
   struct rtlfsmstate_list *TO;
   rtlfsmasg_list          *ASSIGN;
   vexexpr                 *VEX_COND;
   long                     FLAGS;
   void                    *USER;

 } rtlfsmtrans_list;

/*------------------------------------------------------------\
|                                                             |
|                           Rtl Fsm                           |
|                                                             |
\------------------------------------------------------------*/

 typedef struct rtlfsm_list
 {
   struct rtlfsm_list    *NEXT;
   char                  *NAME;
   rtlfsmstate_list      *STATE;
   rtlfsmtrans_list      *TRANS;
   authtable             *HASH_STATE;
   rtlbivex_list         *BIVEX;
   rtlbivex_list        **LAST_BIVEX;
   unsigned char          TYPE;
   long                   FLAGS;
   void                  *USER;

 } rtlfsm_list;

/*------------------------------------------------------------\
|                                                             |
|                       Rtl Figure                            |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rtlfig_list
  {
    struct rtlfig_list *NEXT;
    char               *NAME;
    rtlasg_list        *ASSIGN;
    rtlfsm_list        *FSM;
    rtldecl_list       *DECLAR[ RTL_MAX_DECLAR_TYPE ];
    authtable          *HASH_DECLAR;
    long                FLAGS;
    void               *USER;

  } rtlfig_list;

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  extern rtlfig_list *HEAD_RTLFIG;

  extern char        *RTL_DECLAR_TYPE[ RTL_MAX_DECLAR_TYPE ];
  extern char        *RTL_KIND_TYPE[ RTL_MAX_KIND_TYPE ];
  extern char        *RTL_DIR_TYPE[ RTL_MAX_DIR_TYPE ];
  extern char        *RTL_BIVEX_TYPE[ RTL_MAX_BIVEX_TYPE ];
  extern char        *RTL_ASG_TYPE[ RTL_MAX_ASG_TYPE ];
  extern char        *RTL_ASG_REGISTER_TYPE[ RTL_MAX_ASG_REGISTER_TYPE ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Alloc Functions                    |
|                                                             |
\------------------------------------------------------------*/

  extern   rtlfig_list *allocrtlfig __P(());
  extern  rtldecl_list *allocrtldecl __P(());
  extern        rtlsym *allocrtlsym __P((unsigned int Width));
  extern   rtlasg_list *allocrtlasg __P(());
  extern rtlbivex_list *allocrtlbivex __P(());
  extern   rtlfsm_list *allocrtlfsm __P(());
  extern rtlfsmtrans_list *allocrtlfsmtrans __P(());
  extern rtlfsmstate_list *allocrtlfsmstate __P(());
  extern rtlfsmasg_list *allocrtlfsmasg __P(());

/*------------------------------------------------------------\
|                                                             |
|                           Free Functions                    |
|                                                             |
\------------------------------------------------------------*/

  extern           void  freertlfig __P((rtlfig_list *Figure));
  extern           void  freertlasg __P((rtlasg_list *Asg));
  extern           void  freertlbivex __P((rtlbivex_list *BiVex));
  extern           void  freertldecl __P((rtldecl_list *Decl));
  extern           void  freertlsym __P((rtlsym *Sym));
  extern           void  freertlfsmasg __P((rtlfsmasg_list *FsmAsg));
  extern           void  freertlfsmstate __P((rtlfsmstate_list *fsmstate));
  extern           void  freertlfsmtrans __P((rtlfsmtrans_list *fsmtrans));
  extern           void  freertlfsm __P((rtlfsm_list *Fsm));

/*------------------------------------------------------------\
|                                                             |
|                            Add Functions                    |
|                                                             |
\------------------------------------------------------------*/

  extern   rtlfig_list *addrtlfig __P((char *Name));
  extern  rtldecl_list *addrtldecl __P((rtlfig_list *Figure, vexexpr *Atom, int Type));
  extern   rtlasg_list *addrtlasg __P((rtlfig_list *Figure, vexexpr *VexAtom, int Type));
  extern   rtlasg_list *addrtlasgafter __P((rtlfig_list *Figure, rtlasg_list *PrevAssign, vexexpr *VexAtom, int Type));
  extern rtlbivex_list *addrtlasgbivex __P((rtlfig_list *Figure, rtlasg_list *Assign, vexexpr *VexCond, vexexpr *VexData, int Type));

  extern rtlfsmasg_list *addrtlfsmstateasg __P((rtlfig_list *Figure, rtlfsm_list *Fsm, rtlfsmstate_list *State, vexexpr *VexAtom, vexexpr *VexData));
  extern rtlfsmasg_list *addrtlfsmtransasg __P((rtlfig_list *Figure, rtlfsm_list *Fsm, rtlfsmtrans_list *Trans, vexexpr *VexAtom, vexexpr *VexData));
  extern rtlfsmtrans_list *addrtlfsmtrans __P((rtlfig_list *Figure, rtlfsm_list *Fsm, rtlfsmstate_list *StateFrom, rtlfsmstate_list *StateTo, vexexpr *VexCond));
  extern rtlfsmstate_list *addrtlfsmstate __P((rtlfig_list *Figure, rtlfsm_list *Fsm, char *Name));
  extern   rtlfsm_list *addrtlfsm __P((rtlfig_list *Figure, char *Name));
  extern rtlbivex_list *addrtlfsmbivex __P((rtlfig_list *Figure, rtlfsm_list *Fsm, vexexpr *VexCond, vexexpr *VexData, int Type));

/*------------------------------------------------------------\
|                                                             |
|                            Del Functions                    |
|                                                             |
\------------------------------------------------------------*/

  extern            int  delrtlfig __P((char *Name));
  extern            int  delrtlasg __P((rtlfig_list *Figure, rtlasg_list *Assign));

/*------------------------------------------------------------\
|                                                             |
|                         Search Functions                    |
|                                                             |
\------------------------------------------------------------*/

  extern   rtlfig_list *searchrtlfig __P((char *Name));
  extern  rtldecl_list *searchrtldecl __P((rtlfig_list *Figure, char *Name));
  extern        rtlsym *searchrtlsym __P((rtlfig_list *Figure, char *Name, short Index));
  extern rtlfsmstate_list *searchrtlfsmstate __P((rtlfig_list *Figure, rtlfsm_list *Fsm, char *Name));

/*------------------------------------------------------------\
|                                                             |
|                            Get Functions                    |
|                                                             |
\------------------------------------------------------------*/

  extern  rtlsym *getrtlsymdecl __P((rtldecl_list *Declar, short Index));
  extern  rtlsym *getrtlsymdeclpos __P((rtldecl_list *Declar, int Position));

/*------------------------------------------------------------\
|                                                             |
|                          View Functions                     |
|                                                             |
\------------------------------------------------------------*/

  extern           void  viewrtlsym __P((rtlsym *Symbol));
  extern           void  viewrtldecl __P((rtldecl_list *Decl));
  extern           void  viewrtlbivex __P((rtlbivex_list *BiVex));
  extern           void  viewrtlasg __P((rtlasg_list *Asg));
  extern           void  viewrtlfig __P((rtlfig_list *Figure));
  extern           void  viewrtlfsm __P((rtlfsm_list *Fsm));


# endif
