/*
 * $Author: alliance $
 * $Id: lax100.h,v 1.1.1.1 1998/10/21 16:32:42 alliance Exp $
 * $Date: 1998/10/21 16:32:42 $
 */
/*
 * $Log: lax100.h,v $
 * Revision 1.1.1.1  1998/10/21 16:32:42  alliance
 * fpmap import
 *
 */

#ifndef lax_h
#define lax_h

/*----------------------------------------------------------------------*/
/*                           Nested includes                            */
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*                        Constant declarations                         */
/*----------------------------------------------------------------------*/

# define LAX_CHAIN	(1 << 0)
# define LAX_PTYPE	(1 << 1)

# define	FLAG_MODE		(1 << 0)
# define	FLAG_LEVEL		(1 << 1)
# define	FLAG_DELAY		(1 << 2)
# define	FLAG_EARLY		(1 << 3)
# define	FLAG_SIGNAL		(1 << 4)
# define	FLAG_TRANSN		(1 << 5)
# define	FLAG_TRANSP		(1 << 6)
# define	FLAG_SLOPE		(1 << 7)
# define	FLAG_CAPI		(1 << 8)
# define	FLAG_CAPO		(1 << 9)
# define	FLAG_IMPI		(1 << 10)
# define	FLAG_BUFI		(1 << 11)
# define	FLAG_CLOCK		(1 << 12)

/*----------------------------------------------------------------------*/
/*                          Macro declarations                          */
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*                          Type declarations                           */
/*----------------------------------------------------------------------*/

typedef struct lax_param {
    int			 flag;
    int			 mode;
    int			 level;
    long		 max_slope_time;
    int			 aux;
    int			 num_trans_n;
    int			 num_trans_p;
    chain_list		*early_po;
    ptype_list		*delay_pi;
    ptype_list		*imp_pi;
    ptype_list		*capa_po;
    ptype_list		*capa_pi;
    ptype_list		*buff_pi;
    chain_list		*saved_aux;
    chain_list		*clock;
} lax_param_t;

/*----------------------------------------------------------------------*/
/*                        Stucture declarations                         */
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*                        Variable declarations                         */
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*                         Function prototypes                          */
/*----------------------------------------------------------------------*/

extern	lax_param_t *laxnewparam  __P(( void ));
extern	lax_param_t *laxloadparam __P(( char *FileName ));
extern	void	     laxsaveparam __P(( lax_param_t *Param, char *FileName ));

#endif /* lax_h */
