/*
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail support     : mailto:alliance-support@asim.lip6.fr
 * 
 * This progam is  free software; you can redistribute it  and/or modify it
 * under the  terms of the GNU  General Public License as  published by the
 * Free Software Foundation;  either version 2 of the License,  or (at your
 * option) any later version.
 * 
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef grf605_h
#define grf605_h

/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  GRF                                                          **/
/**                                                               **/
/**  Version 6.05                                                 **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static char *ident_grf="@(#)(RFG) librairy header, version 6.05 (1999/10/07)";

/*******************************************************************/

char *rfg();

#if 0
char *rfg(width, high, n_bus, flip_flop, inverse_data,
          low_power, write_enable, inverse_we, stuck,
          hard_connectors, msb, block_type, name_blocks,
          layout, outline, vhdl, pat, data, netlist, 
          icon)
                       /* Function and possible values for following vars : */

  long width;          /* Number of registers (2<=width<=256). */
                       /* Value must be even.                  */
  long high;           /* Number of bits in register words (2<=high<=64). */
                       /* Value must be even.                             */
  long n_bus;          /* Number of read bus : 0 = 1 read bus; */
                       /*                      1 = 2 read bus. */
  long flip_flop;      /* 0 = level sensitive latch;    */
                       /* 1 = edge-triggered flip-flop. */
  long inverse_data;   /* 0 = data out has same polarity than data in;   */
                       /* 1 = data out polarity is reverse than data in. */
  long low_power;      /* 0 = high consumption option; */
                       /* 1 = low consumption option.  */
  long write_enable;   /* 0 = no write enable signal; */
                       /* 1 = write enable signal.    */
  long inverse_we;     /* 0 = write enable active high; */
                       /* 1 = write enable active low.  */
  long stuck;          /* 0 = register at address 0 is normal;                */
                       /* 1 = register at address 0 is stuck to a null value. */
  long hard_connectors;/* 0 = datapath connectors are multi-access; */
                       /* 1 = all conectors are hard (one-access).  */
  long msb;            /* 0 = index 0 is gived to the less significant bit of each bus; */
                       /* 1 = index 0 is gived to the most significant bit of each bus. */

  long block_type;     /* 0 = generate an optimised registers block        */
                       /*     (uncompatible with generated decoder block), */
                       /* 1 = generate a registers block                   */
                       /*     (compatible with generated decoder block),   */
                       /* 2 = generate a decoder block,                    */
                       /* 3 = generate a complet registers bank.           */

  char *name_blocks;   /* If = NULL : a name must be generated by the function to prefix blocks, */
                       /* else take the indicate name to prefix blocks.                          */
  
  long layout;         /* !0 = generate a layout view block files. */
  long outline;        /* !0 = generate a outline view block file. */
  long vhdl;           /* !0 = generate a vhdl view block file. */
  long pat;            /* !0 = generate a pat view block file. */
  long data;           /* !0 = generate a data sheet file. */
  long netlist;        /* !0 = generate a connectors netlist. */
  long icon;           /* !0 = generate a icon view block file. */
#endif

/*******************************************************************/

#endif
