/*
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail support     : mailto:alliance-support@asim.lip6.fr
 * 
 * This progam is  free software; you can redistribute it  and/or modify it
 * under the  terms of the GNU  General Public License as  published by the
 * Free Software Foundation;  either version 2 of the License,  or (at your
 * option) any later version.
 * 
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/*
 * %% \textrm{This File Looks Nicer with\textsf{ LGrind} and \LaTeXe.}       %%
 * %|                                                                        |%
 * %| $Id: GenericGN.h,v 1.4 1999/11/10 13:38:47 gregoire Exp $      |%
 * %|                                                                        |%
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |          Alliance CAD System 3.2b                                   | |%
 * %| |     F p G e n   P a c k a g e   1.10                               | |%
 * %| |                                                                    | |%
 * %| |  Copyright(c) 95-97, MASI, CAO-VLSI Team                           | |%
 * %| |                                                                    | |%
 * %| |  Author    :            Jean-Paul CHAPUT                           | |%
 * %| |  E-mail    :        cao-vlsi@masi.ibp.fr                           | |%
 * %| | ================================================================== | |%
 * %| |  Header    :        "GenericGN.h"                                  | |%
 * %| | ****************************************************************** | |%
 * %| |  This file is copied into `$(ALLIANCE_TOP)/include/gfp110.h'.               | |%
 * %| |  Modules related to this header :                                  | |%
 * %| |      o  "UtBase.c"                                                 | |%
 * %| |      o  "UtEnv.c"                                                  | |%
 * %| |      o  "UtTechno.c"                                               | |%
 * %| |      o  "UtFlat.c"                                                 | |%
 * %| |      o  "UtXlong.c"                                                | |%
 * %| |      o  "UtUser.c"                                                 | |%
 * %| |      o  "UtMBKLo.c"                                                | |%
 * %| |      o  "UtMBKPh.c"                                                | |%
 * %| |      o  "UtFileDPR.c"                                              | |%
 * %| |      o  "UtPowerBar.c"                                             | |%
 * %| |      o  "UtHierarchy.c"                                            | |%
 * %| |      o  "ScLibGN.c"                                                | |%
 * %| |      o  "FpLibGN.c"                                                | |%
 * %| |      o  "SharedGN.c"                                               | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 * %|                                                                        |%
 */


# ifndef  __GenericGN__
#   define  __GenericGN__

#     include  <sys/param.h>
#     include  <stdlib.h>


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |            Compiler and Architecture Dependant Includes            | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */


#   ifdef  __STDC__
      /* Compiler is ANSI C compliant. */
#     include  <unistd.h>
#     include  <stdarg.h>

#     define   __FP(  arguments )      arguments
#     define   __FPV( arguments )      arguments

#     define   __KR_C(   code )
#     define   __ANSI_C( code )        code
#   else
      /* Compiler is K&R C. */
#     include  <unistd.h>
#     include  <varargs.h>

#     define   __FP(  arguments )     ()
#     define   __FPV( arguments )     (va_alist) va_dcl

#     define   __KR_C(   code )        code
#     define   __ANSI_C( code )
#   endif

    /* Missing functions prototypes for GNU CC. */
/* #include  "gnudefs.h" */
    /* MBK standart includes. */
#   include   MUT_H
#   include   MLO_H
#   include   MPH_H
#   include   MLU_H

#   ifdef  __DBG__
      /* Compile with debug specific code. */
#     define  __DBG( code )  code
#   else
      /* Compile without debug specific code. */
#     define  __DBG( code )
#   endif


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                  Section for Module : `UtBase.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define               TRUE                            1
#   define               FALSE                           0
#   define               EOL                  ((char*)NULL)
#   define        C_SUPP_MaxLenString                16384
#   define        C_SUPP_MBKSZNAME                      64
#   define        F_GfpUT_ModuleAdd                      1
#   define        F_GfpUT_ModuleGet                      2
#   define        C_GfpUT_ModuleMaxNB                   32
#   define        C_GfpUT_ArgLcNB                       32
#   define        C_GfpUT_ArgLcPosUnknow                33
#   define        C_UtBas_ErrorModeExit                  0
#   define        C_UtBas_ErrorModeKill                  1

extern long  GfpUT_GetModuleId    __FP(( char *aName, long  aFlags ));
extern void  GfpUT_AddError       __FP(( long  aModuleId, long  aCode,
                                                          char *aForm ));
extern void  GfpUT_PrintError     __FP(( long  aId, ... ));
extern void  UtBas_SetErrorMode   __FP(( long  aMode ));
extern void  GfpUT_AddWarng       __FP(( long  aModuleId, long  aCode,
                                                          char *aForm ));
extern void  GfpUT_PrintWarng     __FP(( long  aId, ... ));
extern void  UtBas_Init           __FP(( void ));

extern void  GfpUT_InitArgLc      __FP((  int  aArgC, char *aArgV[] ));
extern char *GfpUT_GetArgLcByPos  __FP(( long  aPos,  long *aPtGetNB ));
extern long  GfpUT_GetArgLcByName __FP(( char *aName, long *aPtGetNB ));
extern char *GfpUT_GetArgLcRemain __FP(( void ));

extern long  UtBas_PrintFMark    __FP(( void ));
extern long  UtBas_PrintFFree    __FP(( long  aMark ));
extern char *UtBas_PrintF        __FP(( char *aFormat, ... ));
extern char *UtBas_PrintFAdd     __FP(( char *aStr, ... ));
extern char *UtBas_vPrintFAdd    __FP(( char *aStr,    char *aFormat,
                                                    va_list  ArgList ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                   Section for Module : `UtEnv.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

typedef struct {
  char *RDS_TECHNO_NAME; /* Techno file name.        */
  char *FPGEN_LIB;       /* FpGen dedicated library. */
  char *FPGEN_TARGET;    /* FpGen target library.    */
  } UtEnv_Environ_t;

extern UtEnv_Environ_t UtEnv_Environ;
extern          void   UtEnv_Init __FP(( void ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                 Section for Module : `UtTechno.c'                  | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        C_UtTec_TypeUnknow       2
#   define        C_UtTec_TypeCMOS2        3
#   define        C_UtTec_TypeAsGa3        4
#   define        C_UtTec_FamilyCMOS       2
#   define        C_UtTec_FamilyAsGa       3

/* Structure holding all topologicals data associated to a techno. */
typedef struct {
  long  Type;          /* Type of technology.                   */
  long  PowerLayer;    /* Layer of the power supplies.          */
  long  PowerWideVDD;  /* Wide of the VDD power.                */
  long  PowerWideVSS;  /* Wide of the VDD power.                */
  long  SliceHeight;   /* Height of the slice.                  */
  long  ThruLayer;     /* Layer of horizontal feed through.     */
  long  ThruPitch;     /* Feed through vertical pitch.          */
  long  ThruWide;      /* Wide of horizontal feed through.      */
  long  ThruNB;        /* Number of feed through per slice.     */
  long  ThruTop;       /* Fist feed through from the top AB.    */
  long  ThruBot;       /* Fist feed through from the bottom AB. */
  char  LibrarySuffix; /* Suffix of the leaf cells.             */
  } UtTec_V_t;

extern UtTec_V_t  UtTec_V;

extern void  UtTec_Init   __FP(( char *aPath ));
extern long  UtTec_Family __FP(( void ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                   Section for Module : `UtLib.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        C_UtLib_TargetUnknown      2
#   define        C_UtLib_TargetFpLib        3
#   define        C_UtLib_TargetScLib        4

typedef struct {
  long  Type;  /* Type of target library. */
  } UtLib_V_t;

extern UtLib_V_t  UtLib_V;

extern    void    UtLib_Init   __FP(( char* ));
extern    long    UtLib_Target __FP(( void ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                  Section for Module : `UtFlat.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

extern void  UtFlt_Init           __FP(( void ));
extern long  UtFlt_XYFlatPhFig
  __FP(( phfig_list *aPhFig, long aYFlat, long aXFlat, char aTransf));
extern long  UtFlt_XYUnFlatPhFig   __FP(( phfig_list *aPhFig ));
extern void  UtFlt_HrXYUnFlatPhFig __FP(( phfig_list *aPhFig ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                 Section for Module : `UtXlong.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        C_GfpUT_XLSIZE                 4  /* 128 bits. */
#   define        C_GfpUT_BaseOctal              3
#   define        C_GfpUT_BaseBinary             1
#   define        C_GfpUT_BaseHexadecimal        4

extern long  DP_LGSIZE;  /* Number of long used for a eXtended Long. */

extern void  UtXlg_Init        __FP(( void ));
extern long *GfpUT_XlAlloc     __FP(( void ));
extern void  GfpUT_XlSetLong
               __FP(( long *aPtXlong, long  aLong, long  aValue ));
extern void  GfpUT_XlFree      __FP((long *aPtXlong ));
extern long  GfpUT_XlGetBit    __FP(( long *aPtXlong, long  aBit ));
extern long  GfpUT_XlStrCheck  __FP(( char *aStringNumber ));
extern void  GfpUT_XlStrToXl   __FP(( char *aStringNumber, long *aPtXlong ));
extern char *GfpUT_XlToStr
               __FP((long *aPtXlong, long aConstWidth, long aBaseValue ));
extern char *GfpUT_XlToStrVHDL __FP(( long *aPtXlong, long  aConstWidth ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                  Section for Module : `UtUser.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        F_GfpUT_UserCreat               1
#   define        F_GfpUT_UserGet                 0
#   define        F_GfpUT_UserNoFlags             0

#   define        C_GfpUT_UserSigType             1
#   define        C_GfpUT_UserLoConPlace          2
#   define        C_GfpUT_UserLoFigAB             3
#   define        C_GfpUT_UserLoFigPower          4
#   define        C_GfpUT_UserLoFigGlue           5
#   define        C_GfpUT_UserLoFigFlags          6
#   define        C_GfpUT_UserLoInsPower          7
#   define        C_GfpUT_UserPhFigXYFlat         8
#   define        C_GfpUT_UserPhFigPowBar         9
#   define        C_GfpUT_UserTypeOperator       10
#   define        C_GfpUT_UserModelName          11
#   define        C_GfpUT_UserMaxTdupl           11

extern       void  UtUsr_Init __FP(( void ));
#     ifdef  _MUT_H_
extern ptype_list *GfpUT_GetUser
                     __FP(( ptype_list **aPPtHead, long aType, long aFlags ));
extern ptype_list *GfpUT_DelUser
                     __FP(( ptype_list **aPPtHead, long aType, long aFlags ));
extern       long  GfpUT_SetDupUser
                     __FP(( long aType, void *(*aFunc)() ));
extern       void  GfpUT_DupUser __FP(( ptype_list **aPPtUserSrc,
                                        ptype_list **aPPtUserDest ));
#     endif


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                 Section for Module : `UtMBKLo.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        C_GfpUT_ImplicitConNoIndex        -1
#   define        C_GfpUT_TypeConImplicit            2
#   define        C_GfpUT_TypeConVdd                 3
#   define        C_GfpUT_TypeConVss                 4
#   define        C_GfpUT_TypeConNormal              5
#   define        C_GfpUT_IdxTypeUnknow              6
#   define        C_GfpUT_IdxTypeDefault             7
#   define        C_GfpUT_IdxTypeScalar              8
#   define        C_GfpUT_IdxTypeBus                 9
#   define        C_GfpUT_SigTypeUnknow             10
#   define        C_GfpUT_SigTypeScalar             11
#   define        C_GfpUT_SigTypeBusPin             12
#   define        C_GfpUT_SigTypeBus                13


extern char  DP_SEPAR;
extern char  DP_IC[C_SUPP_MaxLenString];

extern       void  UtMLo_Init                __FP(( void ));
extern       char *GfpUT_ConcatName          __FP(( char *aName1,
                                                    char *aName2 ));
extern       char *GfpUT_CheckName           __FP(( char *pin_name ));
extern       long  GfpUT_IsDecimalNumber     __FP(( char *aStr ));
extern       long  GfpUT_StrIndexDecod       __FP(( char *aStr,
                                                    long *aPtOrig,
                                                    long *aPtExtr ));
extern       long  GfpUT_StrSigDecod         __FP(( char *aStr,
                                                    char *aRoot,
                                                    long *aPtOrig,
                                                    long *aPtExtr ));
extern       char *GfpUT_DecodMBKSigName     __FP(( char *aMBKSigName,
                                                    long *aPtSigIndex ));
extern       char *GfpUT_MakeImplicitConName __FP(( char *aInstName,
                                                    char *aConName,
                                                    long  aIndex ));
extern       long  GfpUT_TypeConName         __FP(( char *aConName ));
#     ifdef  _MLO_H_
extern locon_list *Dut_GetLoConBySig         __FP(( lofig_list *aLoFig,
                                                    losig_list *aLoSig ));
extern locon_list *GfpUT_AddLoConEnd         __FP(( lofig_list *aLoFig,
                                                          char *aName,
                                                    losig_list *aLoSig,
                                                          char  aDir ));
#     endif


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                 Section for Module : `UtMBKPh.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

extern void  UtMPh_Pro            __FP(( void ));
extern void  UtMPh_CopyUpCMA      __FP(( char *aCMAName,
                                         char *aInsName,
                                         char *aNewName ));
extern void  UtMPh_CopyUpHoDPThru __FP(( char *aInsName ));
extern void  UtMPh_CopyUpNwell    __FP(( char *aInsName ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                Section for Module : `UtFileDPR.c'                  | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define       C_UtFDP_SideTypeUnknow           32L
#   define       C_UtFDP_SideTypeDefault          16L
#   define       C_UtFDP_SideTypeNorth             1L
#   define       C_UtFDP_SideTypeSouth             2L
#   define       C_UtFDP_SideTypeEast              4L
#   define       C_UtFDP_SideTypeWest              8L
#   define       C_UtFDP_SliceTypeUnknow          -2
#   define       C_UtFDP_SliceTypeDefault         -1  
#   define       C_UtFDP_TrackTypeUnknow       -1024
#   define       C_UtFDP_TrackTypeDefault      -1025
#   define       C_UtFDP_TrackTypeNumber       -1026
#   define       F_UtFDP_FlagLoFigKeep             1

/*
 * This structure append to a logical connector some informations
 * about his associated physical connector.
 *     More than one physical connector can correspond to a logical
 * one.
 */
typedef struct ulocon_place {
                   long  SIDE;   /* Side  of the physical connector. */
                   long  SLICE;  /* Slice of the physical connector. */
                   long  TRACK;  /* Track of the physical connector. */
    struct ulocon_place *NEXT;   /* Next physical connector.         */
    } ulocon_place_list;

/*
 * The two next structures append to a logical figure some informations
 * about his associated physical figure.
 */
typedef struct {
    long  DY1;  /* Number of lambda to add to the bottom of the AB. */
    long  DY2;  /* Number of lambda to add to the top    of the AB. */
    } lofig_ab;

typedef struct {
    long  NUMB;  /* Number of vertical power refreshment. */
    long  WIDE;  /* wide of the power refresment.         */
    } ulofig_power;

typedef struct {
    long  CPC;    /* Number of Cells per column.   */
    long  ITER;   /* Number of iterations.         */
    long  WIDE;   /* Number of slices of the bloc. */
    } ulofig_glue;

typedef struct {
    long  FLAGS; /* Flags associated to the instance. */
    } ulofig_flags;

typedef struct {
    long  SIDE;  /* Side of the instance where the power will be set. */
    long  WIDE;  /* wide of the power refresment.                     */
    } uloins_power;

extern         void  UtFDP_Init           __FP(( void ));
extern         void  UtFDP_AddLoConPlace  __FP(( locon_list *aLoCon,
                                                       char  aSide ,
                                                       long  aSlice,
                                                       long  aTrack ));
extern         void  UtFDP_DefLoConPlace  __FP(( locon_list *aLoCon,
                                                       char  aSide ,
                                                       long  aSlice,
                                                       long  aTrack ));
extern         void  UtFDP_FreeLoConPlace __FP(( locon_list *aLoCon ));
extern         void  UtFDP_AddLoFigAB     __FP(( lofig_list *aLoFig,
                                                       long  aDY1,
                                                       long  aDY2 ));
extern         void  UtFDP_DelLoFigAB     __FP(( lofig_list *aLoFig ));
extern         void  UtFDP_AddLoFigGlue   __FP(( lofig_list *aLoFig,
                                                       long  aIter,
                                                       long  aWide,
                                                       long  aCPC ));
extern  ulofig_glue *UtFDP_GetLoFigGlue   __FP(( lofig_list *aLoFig ));
extern         void  UtFDP_DelLoFigGlue   __FP(( lofig_list *aLoFig ));
extern         void  UtFDP_SetLoFigFlags  __FP(( lofig_list *aLoFig,
                                                       long  aFlags ));
extern ulofig_flags *UtFDP_GetLoFigFlags  __FP(( lofig_list *aLoFig ));
extern         void  UtFDP_DelLoFigFlags  __FP(( lofig_list *aLoFig ));
extern         void  UtFDP_AddLoFigPower  __FP(( lofig_list *aLoFig,
                                                       long  aPower,
                                                       long  aWide ));
extern         void  UtFDP_DelLoFigPower  __FP(( lofig_list *aLoFig ));
extern         void  UtFDP_AddLoInsPower  __FP(( loins_list *aLoIns,
                                                       char  aSide,
                                                       long  aWide ));
extern         void  UtFDP_DelLoInsPower  __FP(( loins_list *aLoIns ));
extern         void  UtFDP_LoadPlacement  __FP(( char *aFigName ));


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                Section for Module : `UtPowerBar.c'                 | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define       C_GfpUT_PowBarTypeUnknow       2
#   define       C_GfpUT_PowBarTypeVdd          3
#   define       C_GfpUT_PowBarTypeVss          4

/*
 * This structure is used to build an ordered list of power supply
 * coordinates.
 */
typedef struct uphfig_powbar {
                    long  YPOW;  /* Y coordinate of the supply power bar. */
                    char  TYPE;  /* Type of the supply power bar.         */
    struct uphfig_powbar *NEXT;  /* Pointer to the next element.          */
    } uphfig_powbar_list;

extern               void  UtPwB_Init             __FP(( void ));
#     ifdef  _MPH_H_
extern uphfig_powbar_list *GfpUT_AddOPowBar       __FP(( phfig_list *aPhFig,
                                                               long  aYPow,
                                                               char  aType ));
extern uphfig_powbar_list *GfpUT_GetPowBar        __FP(( phfig_list *aPhFig,
                                                               long  aY ));
extern uphfig_powbar_list *GfpUT_GetPowBarBottom  __FP(( phfig_list *aPhFig ));
extern uphfig_powbar_list *GfpUT_GetPowBarTop     __FP(( phfig_list *aPhFig ));
extern               long  GfpUT_GetSliceByPowBar __FP(( phfig_list *aPhFig,
                                                               long  aY ));
extern               void  GfpUT_FreePowBar       __FP(( phfig_list *aPhFig ));
extern               void  GfpUT_HrExtractPowBar  __FP(( phfig_list *aPhFig ));
#     endif


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                Section for Module : `UtHierarchy.c'                | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        C_UtHir_TypeOperatorRouted         2
#   define        C_UtHir_TypeOperatorPlaced         3
#   define        C_UtHir_TypeOperatorUser           4
#   define        C_UtHir_TypeOperatorSubDP          5

typedef struct {
  long  Verbose;
  } UtHir_V_t;

extern UtHir_V_t  UtHir_V;

#     ifdef  _MLO_H_
extern       void  UtHir_Init               __FP(( void ));
extern       long  UtHir_GetOperatorType    __FP(( lofig_list *aLoFig ));
extern       long  UtHir_GetModelType       __FP(( char *aModelName ));
extern       void  UtHir_HierarchCheck      __FP(( lofig_list *ptlofig ));
extern       void  UtHir_HierarchFlattenLo  __FP(( lofig_list *aLoFig ));
extern       void  UtHir_rFlattenCatalPhFig __FP(( phfig_list *aPhFig ));
extern       void  UtHir_rFlattenCatalLoFig __FP(( lofig_list *aLoFig ));
extern lofig_list *UtHir_LoadLoFig          __FP(( char *aModelName ));
#     endif


/*
 * %| /--------------------------------------------------------------------\ |%
 * %| |                                                                    | |%
 * %| |                  Section for Module : `Shared.c'                   | |%
 * %| |                                                                    | |%
 * %| \--------------------------------------------------------------------/ |%
 */

#   define        C_GfpGN_LimitsMinWidthDP     1
#   define        C_GfpGN_LimitsMaxWidthDP   128

#   define        C_GfpGN_FunctionInv          0
#   define        C_GfpGN_FunctionBuff         1
#   define        C_GfpGN_FunctionNand2        2
#   define        C_GfpGN_FunctionNand3        3
#   define        C_GfpGN_FunctionAnd2         4
#   define        C_GfpGN_FunctionAnd3         5
#   define        C_GfpGN_FunctionNor2         6
#   define        C_GfpGN_FunctionNor3         7
#   define        C_GfpGN_FunctionOr2          8
#   define        C_GfpGN_FunctionOr3          9
#   define        C_GfpGN_FunctionXnor2       10
#   define        C_GfpGN_FunctionXor2        11
#   define        C_GfpGN_FunctionNand2mask   12
#   define        C_GfpGN_FunctionNor2mask    13
#   define        C_GfpGN_FunctionXnor2mask   14
#   define        C_GfpGN_FunctionConst       15
#   define        C_GfpGN_FunctionNbuse       16
#   define        C_GfpGN_FunctionBuse        17
#   define        C_GfpGN_FunctionNmux2cs     18
#   define        C_GfpGN_FunctionMux2cs      19
#   define        C_GfpGN_FunctionMux3cd      20
#   define        C_GfpGN_FunctionMux3cs      21
#   define        C_GfpGN_FunctionMux4cs      22
#   define        C_GfpGN_FunctionMux5cs      23
#   define        C_GfpGN_FunctionMux6cs      24
#   define        C_GfpGN_FunctionAdd2s       25
#   define        C_GfpGN_FunctionNul         26
#   define        C_GfpGN_FunctionNpl1        27
#   define        C_GfpGN_FunctionPl1         28
#   define        C_GfpGN_FunctionPmsnw       29
#   define        C_GfpGN_FunctionPmsnwq      30
#   define        C_GfpGN_FunctionPms         31
#   define        C_GfpGN_FunctionPmsq        32
#   define        C_GfpGN_FunctionPmst        33
#   define        C_GfpGN_FunctionPmstq       34
#   define        C_GfpGN_FunctionPdffnw      35
#   define        C_GfpGN_FunctionPdffnwq     36
#   define        C_GfpGN_FunctionPdff        37
#   define        C_GfpGN_FunctionPdffr       38
#   define        C_GfpGN_FunctionPdffq       39
#   define        C_GfpGN_FunctionPdfft       40
#   define        C_GfpGN_FunctionPdffrt      41
#   define        C_GfpGN_FunctionPdffut      42
#   define        C_GfpGN_FunctionPdfftq      43
#   define        C_GfpGN_FunctionUnknow      44
#   define        C_GfpGN_FunctionNumber      C_GfpGN_FunctionUnknow

#   define        C_GfpGN_DriveInv             4
#   define        C_GfpGN_DriveBuff            3
#   define        C_GfpGN_DriveNand2           2
#   define        C_GfpGN_DriveNand3           2
#   define        C_GfpGN_DriveAnd2            2
#   define        C_GfpGN_DriveAnd3            2
#   define        C_GfpGN_DriveNor2            2
#   define        C_GfpGN_DriveNor3            2
#   define        C_GfpGN_DriveOr2             2
#   define        C_GfpGN_DriveOr3             2
#   define        C_GfpGN_DriveXnor2           1
#   define        C_GfpGN_DriveXor2            1

extern char *GfpGN_GenericDispatch __FP(( long  aFunction, ... ));
/* Avalaible "GfpGN_GenericDipatch" calls :
 *
 *     - Boolean generators.
 * extern char *GfpGN_GenericDispatch(char *aModelName,
 *                                    long  aFunction ,
 *                                    long  aWidthDP  ,
 *                                    long  aWidthOp  ,
 *                                    long  aSlice    ,
 *                                    long  aDrive    ,
 *                                    long  aMSB0     ,
 *                                    long  aVHDL     ,
 *                                    long  aNetlist  ,
 *                                    long  aLayout   ,
 *                                    long  aIcon     ,
 *                                    long  aPower    );
 *
 *     - Controlable masks generators.
 *     - Constants generators.
 * extern char *GfpGN_GenericDispatch(char *aModelName,
 *                                    long  aFunction ,
 *                                    long  aWidthDP  ,
 *                                    long  aWidthOp  ,
 *                                    long  aSlice    ,
 *                                    long  aXlMask   ,
 *                                    long  aMSB0     ,
 *                                    long  aVHDL     ,
 *                                    long  aNetlist  ,
 *                                    long  aLayout   ,
 *                                    long  aIcon     ,
 *                                    long  aPower    );
 *
 *     - Buses (three-states) generators.
 *     - Multiplexer generators.
 *     - Adder generators.
 *     - Zero detect generators.
 *     - Registers generators.
 *     - Latchs generators.
 * extern char *GfpGN_GenericDispatch(char *aModelName,
 *                                    long  aFunction ,
 *                                    long  aWidthDP  ,
 *                                    long  aWidthOp  ,
 *                                    long  aSlice    ,
 *                                    long  aMSB0     ,
 *                                    long  aVHDL     ,
 *                                    long  aNetlist  ,
 *                                    long  aLayout   ,
 *                                    long  aIcon     ,
 *                                    long  aPower    );
 */

# endif
