/*
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail support     : mailto:alliance-support@asim.lip6.fr
 * 
 * This progam is  free software; you can redistribute it  and/or modify it
 * under the  terms of the GNU  General Public License as  published by the
 * Free Software Foundation;  either version 2 of the License,  or (at your
 * option) any later version.
 * 
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/* $Id: FpGenMGN.h,v 1.3 1999/10/21 13:50:11 jpc Exp $ */
/*                                                                          */
/*          Alliance CAD System 3.2b                                         */
/*             FpGen Package 1.10                                           */
/*                                                                          */
/*  Copyright(c) 93-97, MASI, CAO-VLSI Team                                 */
/*                                                                          */
/*  Author      :          Jean-Paul CHAPUT                                 */
/*  E-mail      :      cao-vlsi@masi.ibp.fr                                 */
/* ************************************************************************ */
/*  Header      :      "FpGenMGN.h"                                         */
/*                                                                          */
/*      This header file is installed as "fgn110.h" in the include          */
/*  directory of the Alliance distribution.                                 */



#ifndef  __FpGenMGN__
#define  __FpGenMGN__


/* ********************** FpGen Predefined Constants ********************** */


/* Constant name for internal use in modules "FpgenMBK" and "FpgenMGN".
 * Other FpGen constants that have not to be seen by the user are
 * defined in the header "FpgenMBK.h".
 */
#define        C_FgnMGN_ConModeEXPLICIT      2  /* Unsupported */
#define        C_FgnMGN_ConModeIMPLICIT      3  /* Unsupported */
#define        C_FgnMGN_ConModeDEFAULT       4
#define        C_FgnMGN_LSBIndexZero         0
#define        C_FgnMGN_MSBIndexZero         1
#define        C_FgnMGN_DEFAULTWidth        -2
#define        C_FgnMGN_DEFAULTSlice        -3
#define        C_FgnMGN_TraceModeOff         0
#define        C_FgnMGN_TraceModeOn          1

/* Constant name for FPGEN user C source files.
 */
#define        LSB_INDEX_ZERO              C_FgnMGN_LSBIndexZero
#define        MSB_INDEX_ZERO              C_FgnMGN_MSBIndexZero
#define          DEFAULT_WIDTH             C_FgnMGN_DEFAULTWidth
#define          DEFAULT_SLICE             C_FgnMGN_DEFAULTSlice
#define            TRACE_ON                C_FgnMGN_TraceModeOn
#define            TRACE_OFF               C_FgnMGN_TraceModeOff


/* The last argument for functions that have a variable number
   of parameters. */
#define        EOL        ((char*)NULL)


/* ****************** FpGen Macro-Functions Declarations ****************** */


#define  DP_TRACE( aMode )  FgnMGN_Trace( __FILE__, (long)__LINE__, aMode )


extern void  FgnMGN_Trace __FP(( char *aFile, long aLine, long aMode ));
extern void  DP_DEFLOFIG __FP(( char *aFigName ,
                                long  aMaxWidth,
                                long  aMsb0    ));
extern void  DP_SAVLOFIG __FP(( void ));
extern void  DP_CONMODE __FP(( long  aConMode ));
/* extern void  DP_LOCON __FP(( char *aConName, char aConDir, char *aConSig )); */
extern void  DP_LOCON __FP(( char *aConName, char aConDir, char *aConSig ));
extern void  DP_FLATTEN __FP(( void ));

extern void  DP_IMPORT    __FP(( char *ModelName, char *InstName, ... ));
extern void  DP_INV       __FP(( char *InstName, ... ));
extern void  DP_BUFF      __FP(( char *InstName, ... ));
extern void  DP_AND2      __FP(( char *InstName, ... ));
extern void  DP_AND3      __FP(( char *InstName, ... ));
extern void  DP_NAND2     __FP(( char *InstName, ... ));
extern void  DP_NAND3     __FP(( char *InstName, ... ));
extern void  DP_OR2       __FP(( char *InstName, ... ));
extern void  DP_OR3       __FP(( char *InstName, ... ));
extern void  DP_NOR2      __FP(( char *InstName, ... ));
extern void  DP_NOR3      __FP(( char *InstName, ... ));
extern void  DP_XOR2      __FP(( char *InstName, ... ));
extern void  DP_XNOR2     __FP(( char *InstName, ... ));
extern void  DP_NAND2MASK __FP(( char *InstName, ... ));
extern void  DP_NOR2MASK  __FP(( char *InstName, ... ));
extern void  DP_XNOR2MASK __FP(( char *InstName, ... ));
extern void  DP_NMUX2CS   __FP(( char *InstName, ... ));
extern void  DP_MUX2CS    __FP(( char *InstName, ... ));
extern void  DP_MUX3CD    __FP(( char *InstName, ... ));
extern void  DP_MUX3CS    __FP(( char *InstName, ... ));
extern void  DP_MUX4CS    __FP(( char *InstName, ... ));
extern void  DP_MUX5CS    __FP(( char *InstName, ... ));
extern void  DP_MUX6CS    __FP(( char *InstName, ... ));
extern void  DP_BUSE      __FP(( char *InstName, ... ));
extern void  DP_NBUSE     __FP(( char *InstName, ... ));
extern void  DP_ADD2S     __FP(( char *InstName, ... ));
extern void  DP_ADD2F     __FP(( char *InstName, ... ));
extern void  DP_ADSB2F    __FP(( char *InstName, ... ));
extern void  DP_SHIFT     __FP(( char *InstName, ... ));
extern void  DP_CONST     __FP(( char *InstName, ... ));
extern void  DP_NUL       __FP(( char *InstName, ... ));
extern void  DP_PLATCH1   __FP(( char *InstName, ... ));
extern void  DP_NPLATCH1  __FP(( char *InstName, ... ));
extern void  DP_PMSNW     __FP(( char *InstName, ... ));
extern void  DP_PMSNWQ    __FP(( char *InstName, ... ));
extern void  DP_PMS       __FP(( char *InstName, ... ));
extern void  DP_PMSQ      __FP(( char *InstName, ... ));
extern void  DP_PMST      __FP(( char *InstName, ... ));
extern void  DP_PMSTQ     __FP(( char *InstName, ... ));
extern void  DP_PDFFNW    __FP(( char *InstName, ... ));
extern void  DP_PDFFNWQ   __FP(( char *InstName, ... ));
extern void  DP_PDFF      __FP(( char *InstName, ... ));
extern void  DP_PDFFR     __FP(( char *InstName, ... ));
extern void  DP_PDFFT     __FP(( char *InstName, ... ));
extern void  DP_PDFFUT    __FP(( char *InstName, ... ));
extern void  DP_PDFFRT    __FP(( char *InstName, ... ));
extern void  DP_PDFFTQ    __FP(( char *InstName, ... ));
extern void  DP_RFG1C0    __FP(( char *InstName, ... ));
extern void  DP_RFG1CC    __FP(( char *InstName, ... ));
extern void  DP_RFG2C0    __FP(( char *InstName, ... ));
extern void  DP_RFG2CC    __FP(( char *InstName, ... ));
extern void  DP_RFGU1C0   __FP(( char *InstName, ... ));
extern void  DP_RFGU1CC   __FP(( char *InstName, ... ));
extern void  DP_RFGU2C0   __FP(( char *InstName, ... ));
extern void  DP_RFGU2CC   __FP(( char *InstName, ... ));
extern void  DP_MULT      __FP(( char *InstName, ... ));
extern void  DP_MULTP     __FP(( char *InstName, ... ));


#endif
