/* file   : cns211.h
 | date   : Mon Jan 31 15:59:30 MET 2000
 | author : Pascal REMY & Anthony LESTER
 | content: #includes, #defines, structures and variables for the CNS library */

#ifndef CNS
#define CNS


/* 
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail support     : mailto:alliance-support@asim.lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
/* 06/29/95 Cone Netlist Structure #includes: cnsi.h                          */

#include    <stdio.h>
#include    <string.h>
#include    <time.h>

#ifndef     MUT
#include    MUT_H
#endif /* !MUT */

#ifndef     MLO
#include    MLO_H
#endif /* !MLO */

#ifndef     RCN
#include    RCN_H
#endif /* !RCN */

#ifndef     BEH
#include    BEH_H
#endif /* !BEH */
 
/* 10/24/95 Cone Netlist Structure: cns.h                                     */

/* struct lotrs: same as MBK
   typedef struct lotrs {
   struct lotrs   *NEXT;
   struct locon   *DRAIN;
   struct locon   *GRID;
   struct locon   *SOURCE;
   struct locon   *BULK;
   char           *TRNAME;
   long            X,Y;
   unsigned short  WIDTH, LENGTH;
   unsigned short  PS, PD;
   unsigned short  XS, XD;
   char            TYPE;
   struct ptype   *USER;
   } lotrs_list; */

/* struct locon: same as MBK
   typedef struct locon {
   struct locon   *NEXT;
   char           *NAME;
   struct losig   *SIG;
   void           *ROOT;
   char            DIRECTION;
   char            TYPE;
   struct num     *PNODE;
   struct ptype   *USER;
   } locon_list; */

/* ulink union */
typedef union ulink {
    struct lotrs   *LOTRS;      /* if the ulink is a transistor    */
    struct locon   *LOCON;      /* if the ulink is a connector     */
    void           *PTR;        /* if the ulink is of unknown type */
} uulink;

/* uedge union */
typedef union uedge {
    struct cone    *CONE;       /* if the uedge is a cone          */
    struct locon   *LOCON;      /* if the uedge is a connector     */
    void           *PTR;        /* if the uedge is of unknown type */
} uuedge;

/* link structure */
typedef struct link {
    struct link    *NEXT;       /* next branch link                           */
    long            TYPE;       /* link type                                  */
    union ulink     ULINK;      /* the ulink depends on the type of the link, */
    /* it may be a connector or a transistor      */
    float           CAPA;       /* link capacity                              */
    struct ptype   *USER;       /* user defined, probably not empty           */
} link_list;

/* branch structure */
typedef struct branch {
    struct branch  *NEXT;       /* next cone branch                 */
    long            TYPE;       /* branch type                      */
    struct link    *LINK;       /* branch link list                 */
    struct ptype   *USER;       /* user defined, probably not empty */
} branch_list;

/* input and output lists of cones */
typedef struct edge {
    struct edge    *NEXT;       /* next input or output                       */
    long            TYPE;       /* type of input or output                    */
    union uedge     UEDGE;      /* the uedge depends on the type of the edge, */
    /* it may be a cone or a connector            */
    struct ptype   *USER;       /* user defined, probably not empty           */
} edge_list;

/* cone structure */
typedef struct cone {
    struct cone    *NEXT;       /* next cone                               */
    long            INDEX;      /* cone index, unique within a figure      */
    char           *NAME;       /* cone name                               */
    long            TYPE;       /* cone type                               */
    long            TECTYPE;    /* cone technologically oriented type      */
    long            XM, Xm,     /* cone Max and min X coordinates          */
                    YM, Ym;     /* cone Max and min Y coordinates          */
    struct edge    *INCONE,     /* cone input list                         */
                   *OUTCONE;    /* cone output list                        */
    struct branch  *BREXT,      /* list of branches leading to a connector */
                   *BRVDD,      /* list of branches leading to VDD         */
                   *BRGND,      /* list of branches leading to GND         */
                   *BRVSS;      /* list of branches leading to VSS         */
    chain_list     *CELLS;      /* list of cells the cone belongs to       */
    struct ptype   *USER;       /* user defined, probably not empty        */
} cone_list;

/* cell structure */
typedef struct cell {
    struct cell    *NEXT;       /* next cell                         */
    long            TYPE;       /* cell type, check #defines         */
    chain_list     *CONES;      /* list of cones making the cell     */
    struct befig   *BEFIG;      /* the cell's behavioral description */
    struct ptype   *USER;       /* user defined, probably not empty  */
} cell_list;

/* cone netlist structure figure */
typedef struct cnsfig {
    struct cnsfig  *NEXT;       /* next cns figure                      */
    char           *NAME;       /* figure name                          */
    struct locon   *LOCON;      /* external connector list              */
    struct lotrs   *LOTRS;      /* transistor list                      */
    struct cone    *CONE;       /* cone list                            */
    struct cell    *CELL;       /* cell list                            */
    struct lofig   *LOFIG;      /* the cns figure's MBK lofig figure    */
    struct befig   *BEFIG;      /* the cns figure's behavioral figure   */
    struct ptype   *USER;       /* user defined, probably not empty     */
} cnsfig_list;
 
/* 10/23/97 Cone Netlist Structure #defines: cnsd.h                           */

/* note: the first nibble of any USER field is used as a tool signature,      */
/*       0 is for CNS, 1 is for YAGLE, 2 is for TAS and 3 is for SIMULATOR    */

/* CNS environment #defines */

#define CNS_SILENT         ((long) 0x00000000)
#define CNS_TRACE          ((long) 0x00000001)
#define CNS_DEBUG          ((long) 0x00000002)


/* CNS general #defines: user oriented */

#define CNS_UNKNOWN        ((long) 0x08000000)
#define CNS_MULTI_PURPOSE  ((long) 0x04000000)
#define CNS_SEEN           ((long) 0x02000000)
#define CNS_INDEX          ((long) 0x01000000)
#define CNS_POWER          ((long) 0x00000001)
#define CNS_VDD            ((long) 0x00000003)
#define CNS_GND            ((long) 0x00000005)
#define CNS_VSS            ((long) 0x00000009)


/* types for the DIRECTION field of connectors */

#define CNS_I              ((char) 'I')         /* I */
#define CNS_O              ((char) 'O')         /* O */
#define CNS_B              ((char) 'B')         /* B */
#define CNS_Z              ((char) 'Z')         /* Z */
#define CNS_T              ((char) 'T')         /* T */
#define CNS_X              ((char) 'X')         /* X */
#define CNS_VDDC           ((char) 'D')         /* Vdd */
#define CNS_GNDC           ((char) 'G')         /* Gnd */
#define CNS_VSSC           ((char) 'S')         /* Vss */


/* types for the USER field of connectors */

#define CNS_INDEX          ((long) 0x01000000)
#define CNS_SIGINDEX       ((long) 0x00200000)
#define CNS_NODELIST       ((long) 0x00400000)
#define CNS_EXT            ((long) 0x00001000)
#define CNS_CONE           ((long) 0x00000100)


/* types for the TYPE field of signals */

#define CNS_SIGINT         ((char) 'I' )
#define CNS_SIGEXT         ((char) 'E' )
#define CNS_SIGVDD         ((char) 'D' )
#define CNS_SIGVSS         ((char) 'S' )
#define CNS_SIGTRANSP      ((char) 'T' )


/* types for the TYPE field of transistors */

#define CNS_TE             ((char) TRANSN)      /* E */
#define CNS_TD             ((char) TRANSP)      /* D */
#define CNS_TN             ((char) TRANSN)      /* N */
#define CNS_TP             ((char) TRANSP)      /* P */


/* types for the USER field of transistors */

#define CNS_INDEX          ((long) 0x01000000)
#define CNS_LINKTYPE       ((long) 0x00000001)
#define CNS_DRIVINGCONE    ((long) 0x00000004)
#define CNS_CONE           ((long) 0x00000100)


/* types for the TYPE field of links */
                                                                                                                                                                 /* mask from right to left: power type, number of equipipotentials, active or *//* passive type */

#define CNS_IN             ((long) 0x00003000)  /* In (input connector) */
#define CNS_INOUT          ((long) 0x00005000)  /* InOut (output connector) */
#define CNS_2EQUIP         ((long) 0x00000010)
#define CNS_3EQUIP         ((long) 0x00000020)
#define CNS_SWITCH         ((long) 0x00000040)  /* _s (CMOS switch) */
#define CNS_COMMAND        ((long) 0x00000080)  /* _c (command) */
#define CNS_ACTIVE         ((long) 0x00000100)
#define CNS_PASSIVE        ((long) 0x00000200)
#define CNS_UP             ((long) 0x00000400)
#define CNS_DOWN           ((long) 0x00000800)
#define CNS_SW             ((long) 0x00010120)  /* S (switch) */
#define CNS_PULL           ((long) 0x00020210)  /* P (pull up or down) */
#define CNS_DRIV_PULL      ((long) 0x00040120)  /* p (driven pull up or down */
#define CNS_DIODE_UP       ((long) 0x00080610)  /* DU (diode orientation) */
#define CNS_DIODE_DOWN     ((long) 0x00080a10)  /* DD (diode orientation) */
#define CNS_RESIST         ((long) 0x00100200)  /* R (resistor) */
#define CNS_CAPA           ((long) 0x00200210)  /* C (capacitor) */
#define CNS_DIPOLE         ((long) 0x00400210)  /* d (dipole) */


/* types for the TYPE field of branches */

#define CNS_VDD            ((long) 0x00000003)  /* Vdd */
#define CNS_GND            ((long) 0x00000005)  /* Gnd */
#define CNS_VSS            ((long) 0x00000009)  /* Vss */
#define CNS_EXT            ((long) 0x00001000)  /* Ext */
#define CNS_NOT_FUNCTIONAL ((long) 0x00000010)  /* Nf */
#define CNS_BLEEDER        ((long) 0x00000030)  /* B */
#define CNS_DEGRADED       ((long) 0x00000040)  /* D */
#define CNS_PARALLEL       ((long) 0x00000100)  /* P (branch model) */
#define CNS_PARALLEL_INS   ((long) 0x00000300)  /* p (branch instance) */
#define CNS_FEEDBACK       ((long) 0x00000400)  /* F */


/* types for the TYPE field of edges */

#define CNS_VDD            ((long) 0x00000003)
#define CNS_GND            ((long) 0x00000005)
#define CNS_VSS            ((long) 0x00000009)
#define CNS_EXT            ((long) 0x00001000)
#define CNS_CONE           ((long) 0x00000100)
#define CNS_BLEEDER        ((long) 0x00000030)  /* bleeder */
#define CNS_COMMAND        ((long) 0x00000080)  /* commmand */
#define CNS_LOOP           ((long) 0x00000200)  /* loop */
#define CNS_FEEDBACK       ((long) 0x00000400)  /* feedback */


/* types for the TYPE field of cones */

#define CNS_VDD            ((long) 0x00000003)  /* Vdd */
#define CNS_GND            ((long) 0x00000005)  /* Gnd */
#define CNS_VSS            ((long) 0x00000009)  /* Vss */
#define CNS_EXT            ((long) 0x00001000)  /* Ext */
#define CNS_CONFLICT       ((long) 0x00000010)  /* C */
#define CNS_TRI            ((long) 0x00000020)  /* T */
#define CNS_MEMSYM         ((long) 0x00000040)  /* M */
#define CNS_LATCH          ((long) 0x00000080)  /* L */
#define CNS_RS             ((long) 0x00000100)  /* S */
#define CNS_FLIP_FLOP      ((long) 0x00000200)  /* F */
#define CNS_MASTER         ((long) 0x00000400)  /* m */
#define CNS_SLAVE          ((long) 0x00000800)  /* s */


/* types for the TECTYPE field of cones */

#define CNS_CMOS           ((long) 0x00000001)  /* Cm */
#define CNS_DUAL_CMOS      ((long) 0x00000003)  /* dC */
#define CNS_VDD_DEGRADED   ((long) 0x00000050)  /* VddD */
#define CNS_GND_DEGRADED   ((long) 0x00000060)  /* GndD */
#define CNS_VSS_DEGRADED   ((long) 0x000000c0)  /* VssD */
#define CNS_NOR            ((long) 0x00000100)  /* Nor */
#define CNS_OR             ((long) 0x00000200)  /* Or */
#define CNS_PR_NOR         ((long) 0x00000400)  /* Pr_Nor */
#define CNS_SBE            ((long) 0x00000800)  /* Sbe */
#define CNS_SBD            ((long) 0x00001000)  /* Sbd */
#define CNS_TRISTATE_O     ((long) 0x00002000)  /* Tristate_o */
#define CNS_SQUIRT_O       ((long) 0x00004000)  /* Squirt_o */
#define CNS_LATCH_O        ((long) 0x00008000)  /* Latch_o */
#define CNS_PR_BUS         ((long) 0x00010000)  /* Pr_Bus */
#define CNS_ZERO           ((long) 0x00020000)  /* Zero */
#define CNS_ONE            ((long) 0x00040000)  /* One */


/* types for the USER field of cones */

#define CNS_BLEEDER        ((long) 0x00000030)
#define CNS_SWITCH         ((long) 0x00000040)
#define CNS_PARALLEL       ((long) 0x00000100)
#define CNS_EXT            ((long) 0x00001000)
#define CNS_LOCON          ((long) 0x00000080)
#define CNS_LOTRSGRID      ((long) 0x00000200)
#define CNS_LOTRS          ((long) 0x00000400)


/* types for the TYPE field of cells */

#define CNS_SUPER_BUFFER   ((long) 0x00000001)  /* Super_Buffer */
#define CNS_TRISTATE_E     ((long) 0x00000002)  /* Tristate */
#define CNS_SQUIRT_BUFFER  ((long) 0x00000004)  /* Squirt_Buffer */
#define CNS_LATCH_E        ((long) 0x00000008)  /* Latch */
#define CNS_READ           ((long) 0x00000010)  /* Read */
#define CNS_MS_FF          ((long) 0x00000020)  /* Ms_Ff */
 
/* 10/26/95 Cone Netlist Structure variables: cnsv.h                          */

/* CNS environment variables */

extern char    *CNS_VERSION;
extern int      CNS_TRACE_MODE;
extern int      CNS_DEBUG_MODE;
extern int      CNS_VIEW_LEVEL;
extern char    *CNS_TECHNO;
extern int      CNS_POWERNUM;
extern int      CNS_MAXLINKNUM;


/* CNS structure variables */

extern cnsfig_list *CNS_HEADCNSFIG;


/* CNS connector names */

extern char    *CNS_VDDNAME;
extern char    *CNS_GNDNAME;
extern char    *CNS_VSSNAME;
extern char    *CNS_GRIDNAME;
extern char    *CNS_SOURCENAME;
extern char    *CNS_DRAINNAME;
extern char    *CNS_BULKNAME;


/* CNS structure debug variables */

extern int      CNS_DEBUG_LEVEL;
extern int      CNS_LC_VIEW;
extern int      CNS_LT_VIEW;
extern int      CNS_CF_VIEW;
extern int      CNS_CE_VIEW;
extern int      CNS_IC_VIEW;
extern int      CNS_OC_VIEW;
extern int      CNS_BH_VIEW;
extern int      CNS_LK_VIEW;
 
/* 10/14/97 Cone Netlist Structure functions: cnsh.h                          */

void            cnsenv();
void            viewcnsptype();
void            addcnslocon();
locon_list     *getcnslocon();
void            viewcnslocon();
void            cone2locon();
void            addcnslotrs();
lotrs_list     *getcnslotrs();
void            viewcnslotrs();
void            cone2lotrs();
void           *initlinkmem();
void           *freelink();
void           *freelklist();
link_list      *addlink();
link_list      *dellink();
link_list      *appendlink();
void            viewlink();
short           lotrsnum();
void           *initbranchmem();
void           *freebranch();
void           *freebrlist();
branch_list    *addbranch();
void            addconebranch();
branch_list    *delbranch();
void            delconebranch();
branch_list    *appendbranch();
void            appendconebranch();
void            viewbranch();
chain_list     *parabrs();
short           testparabrs();
short           brlotrsnum();
void           *initedgemem();
void           *freeedge();
void           *freeeelist();
edge_list      *addedge();
edge_list      *deledge();
edge_list      *appendedge();
void            viewedge();
int             checkincone();
void            addincone();
void            delincone();
void            appendincone();
void            viewincone();
void            addoutcone();
void            deloutcone();
void            appendoutcone();
void            viewoutcone();
void           *initconemem();
void           *freecone();
void           *freecelist();
cone_list      *addcone();
cone_list      *delcone();
cone_list      *appendcone();
cone_list      *getcone();
void            viewcone();
void            coneparabrs();
short           cnbrlotrsnum();
void            locon2cone();
void            lotrs2cone();
void            addconelotrs(); /* new */
void            freeconelotrs(); /* new */
void           *initcellmem();
void           *freecell();
void           *freecllist();
cell_list      *addcell();
cell_list      *delcell();
cell_list      *appendcell();
void            viewcell();
void           *initcnsfigmem();
void           *freecnsfig();
void           *freecglist();
cnsfig_list    *addcnsfig();
cnsfig_list    *delcnsfig();
cnsfig_list    *appendcnsfig();
void            addconelotrsfig(); /* new */
void            cnsfigchain(); /* new */
void            freelotrsconefig(); /* new */
void            freeconelotrsfig(); /* new */
void            viewcnsfig();
void            updatecapa();
int             cnsfigyyparse();
cnsfig_list    *loadcnsfig();
cnsfig_list    *getcnsfig();
short           treatbr();
void            savecnsfig();
void            savecnslofig();
void            cnsstats();
#endif
