/*
 * $Author: ac $
 * $Id: but101.h,v 1.2 1999/10/21 12:51:58 ac Exp $
 * $Date: 1999/10/21 12:51:58 $
 */
/*
 * $Log: but101.h,v $
 * Revision 1.2  1999/10/21 12:51:58  ac
 * Nouvelle version avec les librairies bdd104, abe, abv, abt.
 * Ajout de fpm_network pour accelerer l'optimisation.
 *
 * Revision 1.1.1.1  1998/10/21 16:32:39  alliance
 * fpmap import
 *
 */

#ifndef __but101_h
#define __but101_h

/*----------------------------------------------------------------------*/
/*                        Constant declarations                         */
/*----------------------------------------------------------------------*/

#define BUT_CLOCK_TYPE		0x52151D16
#define BUT_CLOCK_NAME		0x487CD75C

#define BUT_FF_RE		(void *)( 1 << 0 )
#define BUT_FF_FE		(void *)( 1 << 1 )
#define BUT_LATCH_AH		(void *)( 1 << 2 )
#define BUT_LATCH_AL		(void *)( 1 << 3 )

#define BUT_BERIN		(1 << 0)
#define BUT_BEOUT		(1 << 1)
#define BUT_BEBUS		(1 << 2)
#define BUT_BEREG		(1 << 3)
#define BUT_BEAUX		(1 << 4)
#define BUT_BEBUX		(1 << 5)
#define BUT_BEMAX		(1 << 6)
#define BUT_BEALL		(BUT_BEMAX - 1)

#define BUT_VERBOSE		(1 << 0)

#define BUT_BDD_ORDER		(1 << 1)
#define BUT_BDD_FLATTEN		(1 << 2)

#define BUT_SWEEP_ABL		(1 << 1)
#define BUT_SWEEP_BDD		(1 << 2)

/*----------------------------------------------------------------------*/
/*                        Variable declarations                         */
/*----------------------------------------------------------------------*/

extern befig_list *HEAD_BEFIG;

/*----------------------------------------------------------------------*/
/*                         Function prototypes                          */
/*----------------------------------------------------------------------*/

extern void	 but_postfix_name __P((befig_list *befig, char *str));
extern char	*but_unvector_name __P((char *name));
extern void	 but_unvector __P((befig_list *befig, int type));
extern void	 but_substname __P(( befig_list*BehFigure, char *OldName, char *NewName));

extern void	 but_compil __P((befig_list *befig));
extern void	 but_sweep __P(( befig_list *BehFigure, int Flag ));
extern void	 but_makebdd __P(( befig_list *BehFigure, int Flag, chain_list *SavedAux ));

extern int		 but_num_input __P((befig_list *befig));
extern int		 but_num_beout __P((befig_list *befig));
extern int		 but_num_bereg __P((befig_list *befig));
extern int		 but_num_bebux __P((befig_list *befig));

extern befig_list	*but_findbefig __P((befig_list *befig, char *name));
extern beaux_list	*but_findbeaux __P((befig_list *befig, char *name));
extern bebux_list	*but_findbebux __P((befig_list *befig, char *name));
extern bebus_list	*but_findbebus __P((befig_list *befig, char *name));
extern beout_list	*but_findbeout __P((befig_list *befig, char *name));
extern bepor_list	*but_findbepor __P((befig_list *befig, char *name));
extern bereg_list	*but_findbereg __P((befig_list *befig, char *name));
extern berin_list	*but_findberin __P((befig_list *befig, char *name));

extern int		 but_is_bereg __P((befig_list *befig, char *name));
extern int		 but_is_berin __P((befig_list *befig, char *name));
extern int		 but_is_beout __P((befig_list *befig, char *name));
extern int		 but_is_bebus __P((befig_list *befig, char *name));
extern int		 but_is_beaux __P((befig_list *befig, char *name));
extern int		 but_is_bebux __P((befig_list *befig, char *name));
extern int		 but_is_bepor __P((befig_list *befig, char *name));

#endif	/* __but101_h */

