#! /usr/bin/perl

use strict;
use warnings;

use IO::Socket;

print "Clearing all IPTables rules...\n";

system('iptables -F');

my @openPorts;
my @closedPorts;
my @filteredPorts;

print "Selecting ports between 2000 and 2015...\n";

for(my $i = 2000 ; $i < 2000+15 ; $i++)
{
	push(@openPorts, $i);
}

for(my $i = 0; $i < 5; $i++)
{
	my $size = @openPorts;
	my $randomIndex = int(rand($size));
	push(@closedPorts , $openPorts[$randomIndex]);
	splice(@openPorts, $randomIndex, 1);
}

for(my $i = 0; $i < 5; $i++)
{
	my $size = @openPorts;
	my $randomIndex = int(rand($size));
	push(@filteredPorts , $openPorts[$randomIndex]);
	splice(@openPorts, $randomIndex, 1);
}

print "Setting IPtables rules to filter...\n";

foreach(@filteredPorts)
{
	system("iptables -A INPUT -p tcp --dport $_ -j DROP");
}

print "Opening ports...\n";
my @openedPorts;
foreach(@openPorts)
{

	my $port = new IO::Socket::INET (
		LocalHost => '',
		LocalPort => $_,
		Proto => 'tcp',
		Listen => 3,
		Reuse => 1,
		);

	push(@openedPorts, $port);


}

print "Rules set and ports opened!  Press any key to reveal port settings and to reset IPTables rules.\n";

<STDIN>;

system('iptables -F');

@openPorts = sort(@openPorts);
@closedPorts = sort(@closedPorts);
@filteredPorts = sort(@filteredPorts);

print "Open:\n";
print join("\n", @openPorts);
print "\n";

print "Closed:\n";
print join("\n", @closedPorts);
print "\n";

print "Filtered:\n";
print join("\n", @filteredPorts);
print "\n";

